/*
    Name:           GMThreads Header
    Version:        1.3.0.4
    Header version: 1.0
    Copyright:      Copyright  2008 GMThreads by Snake. All rights reserved.
    Author:         Snake [http://gamebaseteam.eu]
    Description:    MultiThreading in GameMaker applications
*/

#ifndef _GMTHREADS_H
#define _GMTHREADS_H

#include <windows.h>
#include <windowsx.h>

typedef double (WINAPI *GMLTHREADINIT)(double);
GMLTHREADINIT GMLThreadInit;
typedef double (WINAPI *GMLTHREADCREATE)(char*);
GMLTHREADCREATE GMLThreadCreate;
typedef double (WINAPI *GMLTHREADSETPRIORITY)(double,double);
GMLTHREADSETPRIORITY GMLThreadSetPriority;
typedef double (WINAPI *GMLTHREADTERMINATE)(double);
GMLTHREADTERMINATE GMLThreadTerminate;
typedef double (WINAPI *GMLTHREADSUSPEND)(double);
GMLTHREADSUSPEND GMLThreadSuspend;
typedef double (WINAPI *GMLTHREADRESUME)(double);
GMLTHREADRESUME GMLThreadResume;
typedef double (WINAPI *GMLTHREADISSUSPENDED)(double);
GMLTHREADISSUSPENDED GMLThreadIsSuspended;
typedef double (WINAPI *GMLTHREADISRUNNING)(double);
GMLTHREADISRUNNING GMLThreadIsRunning;
typedef double (WINAPI *GMLTHREADLASTERROR)();
GMLTHREADLASTERROR GMLThreadLastError;

HINSTANCE GMTHDLL;
bool GMLThreadLoadLibrary(char* dllname)
{
GMTHDLL=LoadLibrary(dllname);
if(GMTHDLL)
{
GMLThreadInit=(GMLTHREADINIT)GetProcAddress(GMTHDLL,"GMLThreadInit");
GMLThreadCreate=(GMLTHREADCREATE)GetProcAddress(GMTHDLL,"GMLThreadCreate");
GMLThreadSetPriority=(GMLTHREADSETPRIORITY)GetProcAddress(GMTHDLL,"GMLThreadSetPriority");
GMLThreadTerminate=(GMLTHREADTERMINATE)GetProcAddress(GMTHDLL,"GMLThreadTerminate");
GMLThreadSuspend=(GMLTHREADSUSPEND)GetProcAddress(GMTHDLL,"GMLThreadSuspend");
GMLThreadResume=(GMLTHREADRESUME)GetProcAddress(GMTHDLL,"GMLThreadResume");
GMLThreadIsSuspended=(GMLTHREADISSUSPENDED)GetProcAddress(GMTHDLL,"GMLThreadIsSuspended");
GMLThreadIsRunning=(GMLTHREADISRUNNING)GetProcAddress(GMTHDLL,"GMLThreadIsRunning");
GMLThreadLastError=(GMLTHREADLASTERROR)GetProcAddress(GMTHDLL,"GMLThreadLastError");
}
return(true);
}

bool GMLThreadFreeLibrary(void)
{
if(FreeLibrary(GMTHDLL))
return(true);
}

#endif
